////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN

@class ActivationInputException;

/**
 * The {@link ActivationInputError} object defines errors related to user input occurring during an activation process.
 */
NS_REFINED_FOR_SWIFT
@interface ActivationInputError : NSObject

- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;

/**
 * Constructor
 * @param errorCode error code (see OrchestrationErrorCodes.h)
 * @param exception exception
 */
- (instancetype)initWithErrorCode:(int)errorCode exception:(nullable NSException *)exception;

/**
 * Constructor
 * @param exception exception that contains an error code and an exception
 */
- (instancetype)initWithActivationInputException:(ActivationInputException *)exception;

/** error code attached to the error (see OrchestrationErrorCodes.h) */
@property (nonatomic, readonly) int errorCode;

/** exception attached to the error */
@property (nonatomic, nullable, readonly) NSException *exception;

@end

NS_ASSUME_NONNULL_END
